//********************************************************************************
//Project Name : Sensorless Source Code
//Date : 2020.12.15
//MCU : MDSF40
//Others : Sensorless ; 8Pole Pairs
//Pakistan - Ceiling fan(DC12V/38W);310rpm
//First Speed : 100rpm 
//Second Speed : 200rpm 
//Third Speed : 250rpm 
//Fourth Speed : 310rpm 

//Ru-v = 0.66R 	 / Rv-w = 0.7R   / Ru-w = 0.59R
//Lu-v = 950.6uH / Lv-w = 1073uH / Lu-w = 774uH

//********************************************************************************
//								     Include
//********************************************************************************
#include "MDSFxx_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//The variables defined by data are placed in the first 128 bytes (0x00~0x7F) address space
//The variables defined by idata are placed in the (0x00~0xFF) address space
//The variable defined by xdata are placed in the external extended RAM  (generally refers to the external 0xF000~0xF1FF space, the specific space size varies with the MCU , and some MCU do not have external RAM)

//The variable defined by data is the fastest, followed by idata, and xdata is slower than the first two
//Variables that are often used are declared with data/idata; variables that are not commonly used are declared with xdata.
//No special declared variables, the default is data//xdata MCU_COMPONENT Mcu_Component;

bit 	IPD_AUTO_TEST_Flag 		= 0;	
bit 	Timer0Flag 				= 0;
bit 	Timer1Flag 				= 0;
bit 	PwmFlag 				= 0;	//PWM MAX INT.
bit 	counter_1s 				= 0;
//bit     bTest = 1;
uint8 	Timer0Count 			= 0;
uint8 	Timer1Count_1s 			= 0;
uint8	Timer1Smart_1s          = 0;
uint16 	Timer1Count_1h 			= 0;
uint16  Timer1Smart_2h          = 0;
uint8 	Timer1Count_user_timer 	= 0;
uint8	Counter_timer           = 0;
idata	uint16	IPWM_RUN_TIME   = 0;
idata	uint16	IPWM_STOP_TIME  = 0;
idata   uint16 	IPDCount 		= 0;
idata   uint8 	SpeedNum_eeprom	= 0;
// idata	signed int	ia_values;
// idata	signed int	ib_values;
		
extern int16 	CurrentCmdTemp;
extern int16	Speed_Ibus_limit;
//********************************************************************************
//								    MAIN
//********************************************************************************
void main(void){
	unsigned int Power_on_delay_counter = 0;
	for(Power_on_delay_counter=0;Power_on_delay_counter<dPOWER_ON_DELAY_Mechanical_Cycle;Power_on_delay_counter++){};
	
	PWM_SetAllOff();
	GPIO_Init();
	PWM_Init();
	Adc_Init();
	Timer_Init();
	OCP_Init();
	MOC_Init();
	Interrupt_Init();
	LVD_Init();
	CAP_Init();
	EXCAP_Init();
	Uart_Definition();

	#if (dUART_MODE == 1)
		Uart_Definition();
	#endif
	
	#if (dIPWM_MODE == 1)//Buzzer.
		IPWM_Init();
	#endif
	
	#if (RF_Control == 1)
		RFDecode_Init();
	#endif
	
	#if (EEPROM_MODE==1)
		EEP_Power_Init_read_data();
	#endif
	
	#if (POWER_CONTROL == 1)
		InitPI_ALL();
		InitPI(&PIParm_Watt);
	#endif
	
	while(1){
		//IR,RF
		//if(bTest == 1)
		//{
		//	bTest = 0;
			//IrDA_CMD = 0xFCC2;//S1
			//IrDA_CMD = 0xFF3C;//S2
			//IrDA_CMD = 0xFE62;//S3
			//IrDA_CMD = 0xFE68;//S4
			//IrDA_CMD = 0xFCC8;//S5
			//IrDA_CMD = 0xFE65;//Boost
		//}
   	    RemoteSpeedSet(IrDA_CMD);
//RemoteSpeedSet(BOOST);
		#if (RF_Control == 1)
			RFDecode_Read();
		#elif (IR_Control == 1)
			IRDecode_Read();
		#else
			#if (VSP_TRI == 0)
				#if (SPEED_CONTROL == 1)
					//SpeedCmd = SPEED_MAX_LIMIT_VALUE;
				#endif
			
				#if (CURRENT_CONTROL == 1)
					//CurrentCmd = IQ_MAX_LIMIT_VALUE;
				#endif
			
				//FLAG.MOTOR_PWM_ENABLE = 1;					//Enable PWM output
			#endif
		#endif

		#if (EEPROM_MODE==1)
			if((SpeedNum != eprom_data) || (FLAG.Smart_Function_eeprom != FLAG.Smart_Function_sw)){
				FLAG.Smart_Function_eeprom = FLAG.Smart_Function_sw;
				eprom_data = SpeedNum;
				EEP_Erase();
				EEP_Write(0x00,eprom_data);
				#if (RF_Control == 1)
					EEP_Write(0x01,RF_Learning_Address[0]);
					EEP_Write(0x02,RF_Learning_Address[1]);
					EEP_Write(0x03,RF_Learning_Address[2]);
				#endif
				EEP_Write(0x04,FLAG.Smart_Function_sw);
			}
		#endif
	//IPD AUTO TEST
			#if (IPD_AUTO_TEST==1)
				IPD_AUTO_TEST_Flag = 1;
			#endif
			if(IPD_AUTO_TEST_Flag == 1){
				if(IPDCount >= PeriodTime1000ms){
					Break_Fun();
					IPD_Init();
					IPDCount = 0;
				}
			}
			
			if(PwmFlag == 1){//PWM MAX INT.
				#if (BEMF_TAILWIND_RES_FUNCTION == 1) || (BEMF_TAILWIND_DIODE_FUNCTION == 1)
					if(MotorState == M_TAILWIND){
						#if (BEMF_TAILWIND_RES_FUNCTION == 1)	
							TailWindDetect_TwoBEMF_Fun();
						#endif
						
						#if (BEMF_TAILWIND_DIODE_FUNCTION == 1)
							#if (BREAK_FUNCTION == 1)
								if(!ZeroPointCheck)
									Break_Fun();
								else
									PWM_SetActive();
								TailWindDetect_TwoBEMF_Fun();
							#else
								#error Wrong Setting BREAK_FUNCTION Disable !!
							#endif
						#endif
					}
				#endif
				PwmFlag = 0;
			}
	//UART		
		#if (dUART_MODE == 1)
			if(RxState == RX_FINISH){
				Uart_ReadPackage_Build();
			}
			if(UartFlag == 1){
				#if (RF_decoding_UR_Enable == 1)
					SFR_PAGE = 0; Debug_A = IR_Byte[0];
					SFR_PAGE = 0; Debug_B = IR_Byte[1];
					SFR_PAGE = 0; Debug_C = IR_Byte[2];
					SFR_PAGE = 0; Debug_D = IR_Byte[3];
					SFR_PAGE = 0; Debug_E = IR_Byte[4];
					SFR_PAGE = 0; Debug_F = IR_Byte[5];
				#elif (IR_decoding_UR_Enable == 1)
					SFR_PAGE = 0; Debug_A = capture_standby_times;
					SFR_PAGE = 0; Debug_B = Capture_High_Header;
					SFR_PAGE = 0; Debug_C = Capture_Counter_ur;
					SFR_PAGE = 0; Debug_D = Capture_Address_ur;
					SFR_PAGE = 0; Debug_E = Ir_data_buffer;
					SFR_PAGE = 0; Debug_F = Ir_data_buffer;
				#elif (Observe_Speed_UI == 1)
					SFR_PAGE = 2; Debug_A = PI_UI;
				#elif (Observe_BEMF == 1)
					SFR_PAGE = 0; Debug_A = BmfV;
					SFR_PAGE = 0; Debug_B = BmfW;
				#else
					SFR_PAGE = 0; Debug_A = Watt;//IPDPattern;//MotorDir;//MotorState;//Watt;
					SFR_PAGE = 0; Debug_B = MotorErrorState;//Vbus_avg;//SMO_D1;//SMO_D2;//MotorSpeed
					SFR_PAGE = 0; Debug_C = EstimatedSpeed;//ia_values;//ib_values;
					SFR_PAGE = 0; Debug_D = Temp_I;//MotorErrorState;//SPEED
					SFR_PAGE = 3; Debug_E = PI_OUT;//EstimatedSpeed;	//PLL
					SFR_PAGE = 0; Debug_F = PI_OUT;//MotorFaultState;	//Speed
				#endif
				
				Uart_Package_Build();
				UartFlag = 0;
			}
		#endif
			
	//Timer0 value
		if(Timer0Flag == 1){	//1ms
			Timer0Flag = 0;

			if((Timer0Count & 0x0F) == 0){// 0.16.32...etc 16ms
				
			}					
			else if((Timer0Count & 0x1F) == 2){//2.34...etc 2 *16ms
				//GET_IQ_MACRO(IqFb);
			}
			else if((Timer0Count & 0x1F) == 4){//4.36...etc 2 *16ms
				//GET_VQ_MACRO(IqPiOut);
			}
			else if((Timer0Count & 0x1F) == 6){//6.38...etc 2 *16ms
				GET_SPEED_MACRO(EstimatedSpeed);
			}
		}
	//Timer1 value
		if(Timer1Flag == 1){				//10ms
			Timer1Flag = 0;
			
		#if (RF_Control == 1)||(IR_Control == 1)
			Timer1Count_1s++;
			if(Timer1Count_1s==100){		//1s
				Timer1Count_1s = 0;
				Timer1Count_1h++;
				if(Timer1Count_1h==3600){	//1h
					Timer1Count_1h=0;
					
					if(FLAG.Counter_Function_sw==1){
						Timer1Count_user_timer++;
						if(Timer1Count_user_timer==Counter_timer){
							FLAG.Counter_Function_sw = 0;
							Timer1Count_user_timer = 0;
							RF_Channel = R_OFF;
							RF_IR_Fun();
						}
					}
				}
				
				#if (RF_Control == 1)
					#if (No_Remote_control_Learn_mode == 0)
						if(Timer1Count_1h==Learning_TIME){
							if(FLAG.RF_Learning_sw==0)
								FLAG.RF_Learning_sw = 1;
						}
					#endif
				#endif
			}
			
			if(FLAG.Smart_Function_sw==1){
				Timer1Smart_1s++;
				if(Timer1Smart_1s==100){		//1s
					Timer1Smart_1s = 0;
					Timer1Smart_2h++;
					if(Timer1Smart_2h==7200){	//2h
						Timer1Smart_2h = 0;
						if(SpeedNum>1){
							SpeedNum-=1;
							
							#if (dIPWM_MODE == 1)
								FLAG.Buzzer_SW = 1;
								Buzzer_TIMES = 1;
								IPWM_RUN_TIME = IPWM_RUN_TIME_OFF;
								IPWM_STOP_TIME = IPWM_STOP_TIME_OFF;
							#endif
								
							if(SpeedNum==1){
								#if (CURRENT_CONTROL == 1)
									CurrentCmd = IR_Current_1_VALUE;
								#endif
							}
							else if(SpeedNum==2){
								#if (CURRENT_CONTROL == 1)
									CurrentCmd = IR_Current_2_VALUE;
								#endif
								}
							else if(SpeedNum==3){
								#if (CURRENT_CONTROL == 1)
									CurrentCmd = IR_Current_3_VALUE;
								#endif
							}
							else if(SpeedNum==4){
								#if (CURRENT_CONTROL == 1)
									CurrentCmd = IR_Current_4_VALUE;
								#endif
							}
						}
						else
							FLAG.Smart_Function_sw   = 0;
					}
				}
			}
		#endif
		}
	}
}

